#######################
# Plotting
#######################

# render a basic plot for the given vectors
# plot(<x>, <y>)

# render a ggplot for the given data frame
# library(ggplot2)
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>))

# render a ggplot for the given data frame with points
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>)) + 
#   geom_point()
# with more details:
#   geom_point(color = "<color>", 
#              shape = <shape>,        # http://www.cookbook-r.com/Graphs/Shapes_and_line_types/
#              size = <size>, 
#              fill = "<fill color>") 

# render a bar chart
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "identity")                                     # "identity" for values, "count" for counts
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "count")                        # "count" for counts

# render a bar chart with custom title and axis labels  
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "identity") +                                   # "identity" for values, "count" for counts
#   xlab("<x-axis label>") + ylab("<y-axis label>") +
#   ggtitle("<graph title>")
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "count") +                      # "count" for counts
#   xlab("<x-axis label>") + 
#   ylab("<y-axis label>") +
#   ggtitle("<graph title>")

# render a bar chart with custom title, axis and legend labels (using labs())
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "identity") +                                   # "identity" for values, "count" for counts
#   labs(x = "<x-axis label>", 
#        y = "<y-axis label>", 
#        title = "<title>", 
#        fill = "<legend title>")

# render a bar chart with custom colors
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "identity") +                                   # "identity" for values, "count" for counts
#   labs(x = "<x-axis label>", 
#        y = "<y-axis label>", 
#        title = "<title>", 
#        fill = "<legend title>") + 
#   scale_fill_manual(values = c("<color 1>", "<color 2>", ..., "<color n>"))   # n = number of bars

# render a bar chart with colors from RColorBrewer package
# # install.packages("RColorBrewer")
# library(RColorBrewer)
# ggplot(data = <dataframe>, 
#        aes(x = <column 1>, y = <column 2>, fill = <column 1>)) +  # fill = <column 1> is optional; no y for counts
#   geom_bar(stat = "identity") +                                   # "identity" for values, "count" for counts
#   labs(x = "<x-axis label>", 
#        y = "<y-axis label>", 
#        title = "<title>", 
#        fill = "<legend title>") + 
#   scale_fill_brewer(palette = "Spectral") # palettes: http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/

# render a line chart with specific line and points properties
# ggplot(data = <dataframe>[<i>:<k>, ],             # plot line graph for a subset <i>:<k> of rows
#        aes(x = <column 1>, y = <column 2>, 
#            group = 1)) +                          # group = 1: connect all points
#   geom_line(color = "<color>", 
#             size = 2,                             # line thickness
#             linetype = "<linetype>") +            # http://www.cookbook-r.com/Graphs/Shapes_and_line_types/
#   geom_point(color = "<color>", 
#              shape = 25,                          # http://www.cookbook-r.com/Graphs/Shapes_and_line_types/
#              size = 8, fill = "<fill color>") + 
#   xlab("<x-axis label>") + ylab("<y-axis label>") +
#   ggtitle("<graph title>")
